<?php
    $footer    = getContent('footer.content', true);
    if($footer)
    $footer    =$footer->data_values
?>

  <!-- Footer Section Starts Here -->
  <footer class="bg-3">
    <div class="container">
        <div class="footer-bottom">
            <div class="footer-widget widget-about">
                <div class="logo">
                    <a href="<?php echo e(route('home')); ?>">
                        <img class="w-100 h-auto" src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo_2.png')); ?>" alt="<?php echo app('translator')->get('logo'); ?>">
                    </a>
                </div>
                <p><?php echo app('translator')->get(@$footer->footer_note); ?></p>

            </div>
            <div class="footer-widget widget-link">
                <h5 class="title cl-white"><?php echo app('translator')->get('Pages'); ?></h5>
                <ul>
                    <?php if($pages->count() > 0): ?>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('pages', ['id' => $item->id, 'slug'=> slug($item->data_values->page_title) ])); ?>"><?php echo __($item->data_values->page_title) ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="footer-widget widget-link">
                <h5 class="title cl-white"><?php echo app('translator')->get('Useful link'); ?></h5>
                <ul>
                    <li><a href="<?php echo e(route('about_us')); ?>"><?php echo app('translator')->get('About Us'); ?></a></li>
                    <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact Us'); ?></a></li>
                    <li><a href="<?php echo e(route('faqs')); ?>"><?php echo app('translator')->get('FAQ'); ?></a></li>
                    <li><a href="<?php echo e(route('order-track')); ?>"><?php echo app('translator')->get('Track Your Order'); ?></a></li>
                </ul>
            </div>

            <div class="footer-widget widget-link widget-contact">
                <h5 class="title cl-white"><?php echo app('translator')->get('Contact Us'); ?></h5>
                <ul>
                    <li>
                        <i class="las la-map-marker"></i>
                        <?php echo e(__(@$footer->contact_address)); ?>

                    </li>
                    <li>
                        <a href="Tel:<?php echo e(@$footer->cell_number); ?>"><i class="las la-phone"></i><?php echo e(@$footer->cell_number); ?></a>
                    </li>
                    <li>
                        <a href="mailto:<?php echo e(@$footer->email); ?>"><i class="las la-envelope"></i><?php echo e(@$footer->email); ?></a>
                    </li>
                </ul>
            </div>


        </div>
        <div class="footer-copyright">
            <div class="copyright-area d-flex flex-wrap align-items-center justify-content-between">
                <div class="left">
                    <p><?php echo e(__(@$footer->copyright_text)); ?></p>
                </div>
                <ul class="social-icons">
                    <?php
                        $socials    = getContent('social_icon.element');
                    ?>

                    <?php if($socials->count() >0): ?>
                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="<?php echo e($item->data_values->url); ?>">
                                <?php
                                    echo $item->data_values->social_icon
                                ?>
                            </a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </ul>
                <div class="right">
                    <?php if(isset($footer->payment_methods)): ?>
                    <img src="<?php echo e(getImage('assets/images/frontend/footer/'.@$footer->payment_methods, "250x30")); ?>" alt="<?php echo app('translator')->get('footer'); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- Footer Section Ends Here -->

<div class="modal fade" id="quickView">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <button type="button" class="close modal-close-btn" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <div class="modal-body">
                <div class="ajax-loader-wrapper d-flex align-items-center justify-content-center">
                    <div class="spinner-border" role="status">
                      <span class="sr-only"><?php echo app('translator')->get('Loading'); ?>...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\visermart_final\1.1\buyer_file\core\resources\views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>