@extends($activeTemplate . 'layouts.master')
@section('content')

    <div class="feature-grid">
        @if ($activePlan)
            <form action="{{ route('user.property.store', @$property->id) }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="create-property-form">

                    <div class="create-property-form-body">
                        <h5>@lang('Property Details')</h5>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form--label">@lang('Property Type')</label>
                                    <select class="form--control" name="property_status" required>
                                        <option value="" disabled selected>@lang('Select one')</option>
                                        <option value="1" @selected(@$property->property_status == 1)>@lang('Sell')</option>
                                        <option value="2" @selected(@$property->property_status == 2)>@lang('Rent')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label class="form--label">@lang('Title')</label>
                                    <input class="form--control" name="title" type="text" value="{{ old('title', @$property->title) }}" required>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form--label required">@lang('Description')</label>
                                    <textarea class="form-control nicEdit" name="description" rows="5">{{ old('description', @$property->description) }}</textarea>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form--label">@lang('Category')</label>
                                    <select class="form--control" name="category_id" required>
                                        <option value="" disabled selected>@lang('Select one')</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}" @selected($category->id == @$property->category_id)>
                                                {{ __($category->name) }} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form--label">@lang('Total Area')</label>
                                    <div class="input-group">
                                        <input class="form-control form--control" name="total_area" type="number" value="{{ old('total_area', @$property->total_area) }}" step="any" step="any" required>
                                        <span class="input-group-text">@lang('sqft')</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Price')</label>
                                        <div class="input-group">
                                            <input class="form-control form--control" name="price" type="number" value="{{ old('price', @$property->price) }}" step="any" required>
                                            <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form--label">@lang('Country')</label>
                                    <select class="form--control select2" name="country_id" required>
                                        <option value="">@lang('Select one')</option>
                                        @foreach ($countries as $country)
                                            <option data-cities="{{ $country->cities }}" value="{{ $country->id }}" @selected($country->id == @$property->country_id)>
                                                {{ __($country->name) }} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form--label">@lang('City')</label>
                                    <select class="form--control select2" name="city_id" required>
                                        @if (!@$property->city_id)
                                            <option value="" disabled selected>@lang('Select one')</option>
                                        @else
                                            @foreach ($cities as $city)
                                                <option value="{{ $city->id }}" @selected($city->id == @$property->city_id)>
                                                    {{ $city->name }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form--label">@lang('Location')</label>
                                    <input class="form--control" name="location" type="text" value="{{ old('location', @$property->location) }}" required>
                                </div>
                            </div>

                            @if ($activePlan->allow_map)
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Google Map') <i class="las la-info-circle" title="@lang('Embed link')"></i></label>

                                        <input class="form--control" name="map" type="text" value="{{ old('map', @$property->map) }}" />
                                    </div>
                                </div>
                            @endif

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form--label">@lang('Tags') </label>
                                    <small class="ms-2">@lang('Separate multiple keywords by') <code>,</code>(@lang('comma'))
                                        @lang('or') <code>@lang('enter')</code> @lang('key')</small>
                                    <select class="form--control select2-auto-tokenize propertyTags" name="tags[]" multiple="multiple">
                                        @if (@$property->tags)
                                            @foreach ($property->tags as $option)
                                                <option value="{{ $option }}" selected>{{ __($option) }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if ($activePlan->amenities)
                        <div class="create-property-form-body border-top">
                            <h5 class="d-inline me-2">@lang('Amenities')</h5>
                            <small class="text--danger"> (@lang('You can add maximum amount of') {{ $activePlan->amenities }} @lang('amenities'))</small>

                            <div class="d-flex justify-content-end align-items-center mb-3">
                                <button class="btn btn--sm btn-outline--secondary amenityAddBtn" type="button">
                                    <la class="la la-plus"></la> @lang('Add Amenity')
                                </button>
                            </div>

                            <div class="amenities-wrapper d-flex flex-wrap gap-3">
                                @isset($property->amenities)
                                    @foreach ($property->amenities as $key => $amenity)
                                        <div class="input-group singleAmenity">
                                            <input class="form-control form--control" name="amenities[{{ $key }}][name]" type="text" value="{{ $amenity->name }}" placeholder="@lang('Name')">
                                            <input class="form-control form--control" name="amenities[{{ $key }}][value]" type="text" value="{{ $amenity->value }}" placeholder="@lang('Value')">
                                            <button class="btn btn-sm btn--danger amenityRemoveBtn h-auto px-3 py-0" type="button"><i class="la la-times"></i></button>
                                        </div>
                                    @endforeach
                                @endisset

                            </div>
                        </div>
                    @endif

                    <div class="create-property-form-body border-top">
                        <h5>@lang('Office Schedule')</h5>

                        <div class="row">

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form--label">@lang('Day Off')</label>
                                    <select class="form--control dayOff" name="day_off[]" multiple>
                                        <option value="saturday">@lang('Saturday')</option>
                                        <option value="sunday">@lang('Sunday')</option>
                                        <option value="monday">@lang('Monday')</option>
                                        <option value="tuesday">@lang('Tuesday')</option>
                                        <option value="wednesday">@lang('Wednesday')</option>
                                        <option value="thursday">@lang('Thursday')</option>
                                        <option value="friday">@lang('Friday')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    @php $openTime = @$property->open_time ? showDateTime(@$property->open_time, 'H:i') : '' @endphp
                                    <label class="form--label">@lang('Office Open')</label>
                                    <input class="form-control form--control" name="open_time" type="time" value="{{ old('open_time', $openTime) }}" autocomplete="off" />
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    @php $closeTime = @$property->close_time ? showDateTime(@$property->close_time, 'H:i') : '' @endphp
                                    <label class="form--label">@lang('Office Close')</label>
                                    <input class="form-control form--control" name="close_time" type="time" value="{{ old('close_time', $closeTime) }}" autocomplete="off" />
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="create-property-form-body border-top">
                        <h5>@lang('Media Content')</h5>
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label class="form--label">@lang('Display Image') </label>
                                    <input class="form-control form--control" id="propertyCoverUpload" name="display_image" type='file' accept=".png, .jpg, .jpeg" @if (!@$property->id) required @endif />
                                    <small>
                                        <i class="la la-info-circle"></i> @lang('The image will be resized into') {{ getFileSize('property') }}
                                    </small>

                                    <div class="image-preview">
                                        <img src="{{ getImage(getFilePath('property') . '/' . @$property->display_image) }}" alt="">
                                    </div>

                                </div>
                            </div>

                            @if ($activePlan->images)
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Gallery Images') <small class="text--danger"> (@lang('You can add maximum amount of') {{ $activePlan->images }} @lang('images'))</small></label>
                                        </label>
                                        <div class="row">
                                            <div class="input-images pb-3"></div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if ($activePlan->videos)
                                <div class="col-md-12">
                                    <div class="form-group">

                                        <div class="file-upload">

                                            <div class="d-flex justify-content-between">
                                                <label class="form--label">
                                                    @lang('Videos') <i class="las la-info-circle" title="@lang('You need to put the youtube embed link only.')"></i>
                                                    <small class="text--danger"> @lang('You can add maximum amount of') {{ $activePlan->videos }} @lang('videos')</small>
                                                </label>
                                                <button class="btn btn--sm btn-outline--secondary addVideoBtn" type="button">
                                                    <i class="las la-plus"></i> @lang('Add Video')
                                                </button>
                                            </div>

                                            @if (@$property->videos)
                                                @foreach ($property->videos as $key => $video)
                                                    <div class="input-group my-3">
                                                        <input class="form-control form--control control-two" name="videos[{{ $key }}]" type="text" value="{{ $video }}" required />
                                                        @if (!$loop->first)
                                                            <button class="input-group-text btn--danger remove-btn text-white" type="button"><i class="las la-times"></i></button>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @endif

                                            <div id="propertyVideoContainer"></div>

                                        </div>

                                    </div>
                                </div>
                            @endif

                        </div>
                        <button class="btn btn--base w-100" type="submit" @disabled(!$activePlan)>@lang('Submit')</button>
                    </div>

                </div>
            </form>
        @else
            <div class="card custom--card">
                <div class="card-body text--warning text-center">
                    <h5 class="text-center">@lang('No Active Plan')</h5>
                    <p class="mb-4">@lang('Currently, you have no subscribed plan. Please buy a plan to publish your properties or add new properties.')</p>

                    <div class="text-center">
                        <a class="btn btn--sm btn--base" href="{{ route('pricing') }}">@lang('Buy a Plan')</a>
                    </div>
                </div>
            </div>
        @endif

    </div>

@endsection

@push('style')
    <style>
        .form--control,
        .image-uploader {
            border-radius: 0.5rem;
        }

        .image-uploader {
            border: 1px solid hsl(var(--black)/0.1);
        }

        .image-preview {
            margin-top: .8rem;
            width: 217px;
            height: 126px;
            padding: 2px;
            border: 1px solid hsl(var(--black)/0.1);
            border-radius: 3px;
        }

        .image-preview img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .input-group-text {
            background-color: #fbfbfb;
            border: 1px solid #e9e9e9;
            border-radius: .5rem;
        }

        :focus-visible {
            outline: none !important;
        }

        .select2-container--default .select2-selection--multiple {
            border-radius: 7px !important;
        }

        .select2-container .select2-selection--multiple {
            min-height: 55px !important;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            margin-top: 10px !important;
        }

        .form--control[type=file] {
            line-height: 55px !important;
        }
    </style>
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/image-uploader.min.js') }}"></script>
@endpush

@push('style-lib')
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/global/css/image-uploader.min.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            @if (old() && old('property_status'))
                $('[name=property_status]').val(@json(old('property_status')));
            @endif

            @if (old() && old('category_id'))
                $('[name=category_id]').val(@json(old('category_id')));
            @endif

            @if (old() && old('city_id'))
                $('[name=city_id]').val(@json(old('city_id')));
            @endif

            @if (old() && old('day_off'))
                $('.dayOff').val(@json(old('day_off')));
            @elseif (isset($property->day_off))
                $('.dayOff').val(@json($property->day_off));
            @endif

            $('select[name="country_id"]').on('change', function() {
                var cities = $(this).find(`option:selected`).data('cities');

                var option = '';

                if (cities && cities.length > 0) {
                    $.each(cities, function(index, value) {
                        option += "<option name='city_id' value='" + value.id + "'>" + value.name + "</option>";
                    });
                } else {
                    option = "<option value=''>@lang('Select City')</option>";
                }
                $('select[name=city_id]').html(option);
            })

            bkLib.onDomLoaded(function() {
                $(".nicEdit").each(function(index) {
                    $(this).attr("id", "nicEditor" + index);
                    new nicEditor({
                        fullPanel: true
                    }).panelInstance('nicEditor' + index, {
                        hasPanel: true
                    });
                });
            });

            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });

            $('.select2-auto-tokenize-aminity').select2({
                dropdownParent: $('.create-property-form'),
                tags: true,
                maximumSelectionLength: {{ $activePlan?->amenities ?? 0 }},
                tokenSeparators: [','],
            });

            $('.select2-auto-tokenize').select2({
                dropdownParent: $('.create-property-form'),
                tags: true,
                maximumSelectionLength: 10,
                tokenSeparators: [','],
            });

            // image uploder
            @if (isset($images))
                let preloaded = @json($images);
            @else
                let preloaded = [];
            @endif

            $('.input-images').imageUploader({
                preloaded: preloaded,
                imagesInputName: 'images',
                preloadedInputName: 'old',
                maxSize: 3 * 1024 * 1024,
                maxFiles: {{ $activePlan?->images ?? 0 }},
            });

            $('.addVideoBtn').on('click', function() {
                let count = $(document).find('.singleVideo').length;
                let max = @json(@$activePlan->videos) * 1;

                if (count < max) {
                    $("#propertyVideoContainer").append(`
                        <div class="input-group my-3 singleVideo">
                            <input type="text" name="videos[]" placeholder="i.e. https://www.youtube.com/embed/WOb4cj7izpE" class="form-control form--control control-two" required />
                            <button type="button" class="input-group-text btn--danger remove-btn text-white"><i class="las la-times"></i></button>
                        </div>
                    `)
                }
            });

            $(document).on('click', '.remove-btn', function() {
                $(this).parent().remove();
            });

            $('.amenityAddBtn').on('click', function() {
                let count = $(document).find('.singleAmenity').length;
                let max = @json(@$activePlan->amenities) * 1;
                if (count < max) {
                    $('.amenities-wrapper').append(`
                        <div class="input-group singleAmenity">
                            <input type="text" name="amenities[${count}][name]" placeholder="@lang('Name')" class="form-control form--control">
                            <input type="text" name="amenities[${count}][value]" placeholder="@lang('Value')" class="form-control form--control">
                            <button type="button" class="btn btn-sm btn--danger h-auto py-0 px-3 amenityRemoveBtn"><i class="la la-times"></i></button>
                        </div>
                    `);
                }
            });

            $(document).on('click', '.amenityRemoveBtn', function() {
                $(this).parent().remove();
            });

            $('.dayOff').select2();


            //image
            function displayImage(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var preview = $(input).parent().find('.image-preview img');
                        $(preview).attr('src', e.target.result);
                        $(preview).addClass('has-image');
                        $(preview).hide();
                        $(preview).fadeIn(650);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#propertyCoverUpload").on('change', function() {
                displayImage(this);
            });

        })(jQuery);
    </script>
@endpush
