@php
    $testimonialElement = getContent('testimonial.element', orderById: true);
@endphp
<section class="testimonials py-120 section-bg">
    <div class="testimonials__shape-one">
        <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
    </div>
    <div class="testimonials__shape-two">
        <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
    </div>

    <div class="container">
        <div class="testimonial-slider">
            @foreach ($testimonialElement as $testimonial)
                <div class="testimonails-card">
                    <div class="testimonial-item">
                        <div class="testimonial-item__content">
                            <div class="testimonial-item__rating">
                                <ul class="rating-list">
                                    @php  echo rating((int)$testimonial->data_values->star);  @endphp
                                </ul>
                            </div>
                            <p class="testimonial-item__desc">{{ __(@$testimonial->data_values->quote) }}</p>
                        </div>
                        <div class="testimonial-item__info">
                            <div class="testimonial-item__thumb">
                                <img class="fit-image" src="{{ getImage('assets/images/frontend/testimonial/' . @$testimonial->data_values->image, '200x200') }}">
                            </div>
                            <div class="testimonial-item__details">
                                <h5 class="testimonial-item__name"> {{ __(@$testimonial->data_values->author) }}</h5>
                                <span class="testimonial-item__designation"> {{ __(@$testimonial->data_values->designation) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
