@php
    $content = getContent('how_work.content', true);
    $element = getContent('how_work.element', false, null, true);
@endphp
<section class="how-to-work-section py-120 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-heading">
                    <h2 class="section-heading__title"> {{ __(@$content->data_values->heading) }} </h2>
                    <p class="section-heading__desc"> {{ __(@$content->data_values->subheading) }}</p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center gy-4">
            @foreach ($element as $item)
                <div class="col-lg-4 col-sm-6">
                    <div class="how-work-item">
                        <div class="how-work-item__header">
                            <span class="how-work-item__icon">
                                @php echo $item->data_values->icon;  @endphp
                            </span>
                            <span class="how-work-item__header-number">
                                {{ ordinal($loop->iteration) }}
                            </span>
                        </div>
                        <div class="how-work-item__content">
                            <h5 class="how-work-item__title"> {{ __($item->data_values->title) }} </h5>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
