@php
    $featureProperty = getContent('feature_property.content', true);
    $properties = App\Models\Property::approved()
        ->featured()
        ->whereHas('user.activePlan')
        ->with('category', 'city', 'country', 'user')
        ->orderBy('id', 'DESC')
        ->get();

@endphp

@if (!blank($properties))
    <section class="feature-section py-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-heading">
                        <h2 class="section-heading__title">{{ __(@$featureProperty->data_values->heading) }}</h2>
                        <p class="section-heading__desc"> {{ __(@$featureProperty->data_values->subheading) }}</p>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                @include('Template::partials.property_grid', ['class' => 'col-lg-4 col-md-6'])
            </div>
        </div>
    </section>
@endif
