@php
    $counterContent = getContent('counter.content', true);
    $counterElement = getContent('counter.element', false, 4);
@endphp
<div class="counter-section py-60">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-heading">
                    <h2 class="section-heading__title">{{ __(@$counterContent->data_values->heading) }}</h2>
                    <p class="section-heading__desc">{{ __(@$counterContent->data_values->subheading) }}</p>
                </div>
            </div>
        </div>
        <div class="counterup-wrapper">
            <div class="counterup-item flex-between">
                @foreach ($counterElement as $counter)
                    <div class="counterup-item__content">
                        <div class="counterup-item__number">
                            <h3 class="counterup-item__title mb-0">
                                <span class="odometer" data-odometer-final="{{ @$counter->data_values->counter_digit }}">0</span>
                            </h3>
                        </div>
                        <span class="counterup-item__text text--black mb-0"> {{ __(@$counter->data_values->title) }}</span>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
