@php
    $blogContent = getContent('article.content', true);
    $blogElement = getContent('article.element', false, 6);
@endphp
<section class="blog py-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading">
                    <h2 class="section-heading__title"> {{ __(@$blogContent->data_values->heading) }} </h2>
                    <p class="section-heading__desc"> {{ __(@$blogContent->data_values->subheading) }} </p>
                </div>
            </div>
        </div>

        <div class="row gy-4 justify-content-center">
            @foreach ($blogElement as $blog)
                <div class="col-lg-4 col-md-6">
                    <div class="blog-item">

                        <div class="blog-item__thumb">
                            <a href="{{ route('article.details', [slug($blog->data_values->title), $blog->id]) }}" class="blog-item__thumb-link">
                                <img src="{{ getImage('assets/images/frontend/article/thumb_' . @$blog->data_values->image, '435x260') }}" class="fit-image">
                            </a>
                        </div>

                        <div class="blog-item__content">
                            <span class="text-list__item-icon me-1 text--base"><i class="las la-calendar"></i></span>
                            {{ showDateTime($blog->created_at, 'd F Y') }}
                            <h5 class="blog-item__title"><a href="{{ route('article.details', [slug($blog->data_values->title), $blog->id]) }}" class="blog-item__title-link border-effect">{{ strLimit(__($blog->data_values->title), 26) }}</a>
                            </h5>
                            <p>@php echo strLimit(strip_tags($blog->data_values->description_nic), 80); @endphp</p>

                            <a href="{{ route('article.details', [slug($blog->data_values->title), $blog->id]) }}" class="text--base mt-2">@lang('Read More')..</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
