@php
    $aboutContent = getContent('about.content', true);
    $aboutElement = getContent('about.element', false, null, true);
@endphp

<div class="about-section py-120 section-bg">
    <div class="about-section__shape-one">
        <img src="{{ asset($activeTemplateTrue . 'images/shapes/city-aside.png') }}">
    </div>
    <div class="container">
        <div class="row gy-4 justify-content-center flex-wrap-reverse">
            <div class="col-lg-6 pe-lg-5">
                <div class="about-left">
                    <div class="about-left__thumb">
                        <img
                            src="{{ getImage('assets/images/frontend/about/' . @$aboutContent->data_values->image, '540x515') }}">
                    </div>

                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-right">
                    <div class="section-heading style-left">
                        <h2 class="section-heading__title"> {{ __(@$aboutContent->data_values->heading) }} </h2>
                        <p class="section-heading__desc">{{ __(@$aboutContent->data_values->content) }} </p>
                    </div>
                    @foreach ($aboutElement as $about)
                        <div class="about-right__item">
                            <span class="about-right__icon">
                                @php
                                    echo $about->data_values->icon;
                                @endphp
                            </span>
                            <div class="about-right__content">
                                <h5 class="about-right__content-title"> {{ __($about->data_values->title) }} </h5>
                                <p class="about-right__desc"> {{ __($about->data_values->description) }} </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
