@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="listing-detials py-120">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-8 col-lg-7">
                    <div class="listing-details">
                        <div class="listing-details__header">
                            <h4 class="listing-details__header-title"> {{ __($property->title) }}</h4>
                            <div class="d-flex align-items-center flex-wrap">
                                <div>
                                    <span class="listing-details-item__icon"> @php echo $property->category->icon @endphp</span>
                                    <span class="listing-details-item__icon-text"> {{ __($property->category->name) }}
                                    </span>
                                </div>

                                <div>
                                    <span class="listing-details-item__icon "><i class="las la-map-marker"></i></span>
                                    <span class="listing-details-item__icon-text">{{ __($property->location) }}, {{ __($property->city->name) }}, {{ __($property->country->name) }}</span>
                                </div>

                                <div class="ms-3">
                                    <span class="location-item__list">
                                        @if ($property->property_status == Status::BUY)
                                            @lang('Buy')
                                        @else
                                            @lang('Rent')
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="listing-details__thumb">
                            <img class="fit-image" src="{{ getImage(getFilePath('property') . '/' . $property->display_image, getFileSize('property')) }}">
                        </div>
                        <div class="listing-details__content">
                            <h5 class="listing-details__title"> @lang('Description ')</h5>
                            <p class="listing-details__desc">@php echo $property->description @endphp</p>

                            <div class="listing-details__date">
                                <h5 class="listing-details__date-title"> @lang('Working Hours')</h5>

                                <div class="listing-details__date-content flex-between gap-3">

                                    @if ($property->open_time)
                                        <div>
                                            <h6 class="title"> @lang('Open') </h6>
                                            <div class="d-flex align-items-center">
                                                <span class="time-icon"><i class="las la-clock"></i></span>
                                                <span class="time">{{ showDateTime($property->open_time, 'h:i A') }}</span>
                                            </div>
                                        </div>
                                    @endif

                                    @if ($property->close_time)
                                        <div>
                                            <h6 class="title"> @lang('Close') </h6>
                                            <div class="d-flex align-items-center">
                                                <span class="time-icon"><i class="las la-clock"></i></span>
                                                <span class="time">{{ showDateTime($property->close_time, 'h:i A') }}</span>
                                            </div>
                                        </div>
                                    @endif

                                    @if (!$property->open_time && !$property->close_time)
                                        <div>
                                            <h6 class="title"> @lang('Open') </h6>
                                            @lang('24/7')
                                        </div>
                                    @endif

                                    @if (!blank($property->day_off))
                                        <div>
                                            <h6 class="title"> @lang('Days Off') </h6>
                                            <div class="d-flex align-items-center">
                                                @php
                                                    $property->day_off = array_map(function ($day) {
                                                        return ucfirst($day);
                                                    }, $property->day_off);
                                                @endphp

                                                <small>
                                                    {{ implode(', ', $property->day_off) }}
                                                </small>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            @if (!blank($property->amenities))
                                <div class="listing-details__amenities">
                                    <h5 class="listing-details__amenities-title"> @lang('Amenities') </h5>
                                    <ul class="amenities-list d-flex flex-wrap gap-1 gap-md-3">
                                        @foreach ($property->amenities as $amenity)
                                            <li class="amenities-list__item bg-light py-2 px-3 rounded">
                                                <span class="me-2">{{ __($amenity->name) }}:</span> <span> {{ __($amenity->value) }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            @if (count($property->videos) || count($property->images))
                                <div class="listing-details__gallery">
                                    <ul class="nav nav-pills  custom--tab tab-three" id="pills-tab" role="tablist">
                                        @if (!blank($property->images))
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="pills-photos-tab" data-bs-toggle="pill" data-bs-target="#pills-photos" type="button" role="tab" aria-controls="pills-photos" aria-selected="true">@lang('Photos')</button>
                                            </li>
                                        @endif

                                        @if (!blank($property->videos))
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link @if (blank($property->images)) active @endif" id="pills-video-tab" data-bs-toggle="pill" data-bs-target="#pills-video" type="button" role="tab" aria-controls="pills-video" aria-selected="false"> @lang('Video')
                                                </button>
                                            </li>
                                        @endif
                                    </ul>
                                    <div class="tab-content" id="pills-tabContent">
                                        @if (!blank($property->images))
                                            <div class="tab-pane fade show active" id="pills-photos" role="tabpanel" aria-labelledby="pills-photos-tab" tabindex="0">
                                                <div class="row gy-4 justify-content-center">
                                                    @foreach ($property->images as $image)
                                                        <div class="col-sm-4 col-xsm-6">
                                                            <a class="gallery-thumb" href="{{ getImage(getFilePath('property') . '/' . $image->name, getFileSize('property')) }}">
                                                                <img src="{{ getImage(getFilePath('property') . '/' . $image->name, getFileSize('property')) }}" alt="">
                                                            </a>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif

                                        @if (!blank($property->videos))
                                            <div class="tab-pane fade @if (!$property->images->count()) show active @endif" id="pills-video" role="tabpanel" aria-labelledby="pills-video-tab" tabindex="0">
                                                <div class="row g-4">
                                                    @foreach ($property->videos as $video)
                                                        <div class="col-lg-6">
                                                            <div class="video-info">
                                                                <iframe src="{{ @$video }}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            @if ($property->map)
                                <div class="listing-details__map">
                                    <h5 class="title">@lang('City') </h5>
                                    <iframe src="{{ old('map', @$property->map) }}" style="border:0;" height="450" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            @endif

                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5">

                    <div class="listing-details-sidebar-wrapper">
                        <div class="listing-details-sidebar">
                            <h5 class="listing-details-sidebar__title"> @lang('Posted By') </h5>
                            <div class="listing-details-sidebar__header">
                                <div class="listing-details-sidebar__header-thumb">
                                    <img src="{{ getImage(getFilePath('userProfile') . '/' . old('image', $property->user->image)) }}" alt="">
                                </div>
                                <div class="listing-details-sidebar__header-info">
                                    <h6 class="name">{{ $property->user->fullname }} </h6>
                                    <span class="title">{{ @$property->user->address->country }}</span>
                                </div>
                            </div>
                            <div class="listing-details-sidebar__info">
                                <ul class="info-list">
                                    <li class="info-list__item"><span class="icon"><i class="las la-map-marker"></i></span>
                                        {{ __(@$property->user->address->address) }},{{ __(@$property->user->address->city) }}
                                    </li>
                                    <li class="info-list__item"><span class="icon"><i class="las la-phone"></i></span>
                                        {{ @$property->user->mobile }} </li>
                                    @if (@$property->user->address->website)
                                        <li class="info-list__item"><span class="icon"> <i class="las la-globe"></i></span>
                                            <a class="text--body" href="{{ $property->user->address->website }}">{{ $property->user->address->website }}</a>
                                        </li>
                                    @endif
                                    <li class="info-list__item"><span class="icon"><i class="las la-envelope"></i></span> {{ @$property->user->email }}
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="listing-details-sidebar">
                            <h5 class="listing-details-sidebar__title"> @lang('Category') </h5>
                            <ul class="text-list style-category">
                                <li class="text-list__item">
                                    <a class="text-list__link" href="{{ route('properties') }}">
                                        <span>@lang('All')</span>
                                        <span>({{ @$totalProperties }})</span>
                                    </a>
                                </li>
                                @foreach ($categories as $category)
                                    <li class="text-list__item"><a class="text-list__link" href="{{ route('properties') }}?category_id={{ $category->id }}"><span>{{ __($category->name) }}</span>
                                            <span>({{ $category->properties_count }})</span></a></li>
                                @endforeach
                            </ul>
                        </div>

                        @if (!blank($property->tags))
                            <div class="listing-details-sidebar">
                                <h5 class="listing-details-sidebar__title"> @lang('Tags') </h5>
                                <ul class="text-list style-tag">
                                    @foreach ($property->tags as $tag)
                                        <li class="text-list__item"><a class="text-list__link" href="{{ route('properties') }}?search={{ $tag }}"> {{ $tag }} </a></li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
