@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <div class="feature-grid py-120">
        <div class="container">
            <div class="row">
                <div class="row">
                    <div class="col-xxl-3 col-xl-4">
                        @include($activeTemplate . 'partials.property_filter')
                    </div>
                    <div class="col-xxl-9 col-xl-8">
                        <div class="d-xl-none d-inline-block">
                            <div class="filter-icon">
                                <i class="las la-list"></i>
                            </div>
                        </div>
                        <div class="row gy-4">
                            <div class="col-lg-12">
                                <div class="property-header">
                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                        <button class="filter-button btn btn--base" type="submit"><i class="las la-filter"></i></button>
                                        <h6 class="property-header__title">
                                            @lang('Showing Properties') : {{ $properties->count() }}
                                        </h6>
                                    </div>
                                    <div class="d-flex align-items-center view-buttons gap-2">
                                        <button class="btn text--body active gridView" type="button">
                                            <i class="fas fa-th-large"></i>
                                        </button>
                                        <button class="btn text--body listView" type="button">
                                            <i class="fas fa-list"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="property-wrapper">
                                    <div class="row g-3 g-md-4">
                                        @include($activeTemplate . 'partials.property_grid', ['class' => 'col-lg-6 col-sm-6 col-xsm-6 property-item'])

                                        @if (blank($properties))
                                            <div class="col-12">
                                                <div class="card custom--card">
                                                    <div class="card-body text-center">
                                                        <h5 class="text-muted mb-0">@lang('No property found!')</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                @if ($properties->hasPages())
                                    <div class="row">
                                        {{ paginateLinks($properties) }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            'use strict';

            $('.listView').on('click', function() {
                $(this).addClass('active');
                $('.gridView').removeClass('active');
                $('.property-wrapper').addClass('list-view');
            });

            $('.gridView').on('click', function() {
                $(this).addClass('active');
                $('.listView').removeClass('active');
                $('.property-wrapper').removeClass('list-view');
            });

        })(jQuery);
    </script>
@endpush
@push('style')
    <style>
        .filter-select.form-select.form--control {
            color: hsl(var(--body-color)) !important;
        }
    </style>
@endpush
