@php
    $user = auth()->user();
    $plan = @$user?->activePlan;
@endphp

<div class="dashboard-sidebar">
    <span class="sidebar-menu__close d-xl-none d-block"><i class="las la-times"></i></span>
    <!-- ========= Sidebar Menu Start ================ -->
    <h5 class="dashboard-sidebar__title">@lang('Dashboard Menus')</h5>
    <ul class="sidebar-menu-list">
        <li class="sidebar-menu-list__item {{ menuActive('user.home') }}">
            <a class="sidebar-menu-list__link" href="{{ route('user.home') }}">
                <span class="icon"><i class="las la-home"></i></span>
                <span class="text">@lang('Dashboard')</span>
            </a>
        </li>
        <li class="sidebar-menu-list__item {{ menuActive('user.property.create') }}">
            <a class="sidebar-menu-list__link" href="{{ route('user.property.create') }}">
                <span class="icon"><i class="las la-building"></i></span>
                <span class="text">@lang('Create Property')</span>
            </a>
        </li>

        <li class="sidebar-menu-list__item {{ menuActive(['user.property.all', 'user.property.edit']) }}">
            <a class="sidebar-menu-list__link" href="{{ route('user.property.all') }}">
                <span class="icon"><i class="las la-city"></i></span>
                <span class="text"> @lang('My Properties')</span>
            </a>
        </li>
        <li class="sidebar-menu-list__item {{ menuActive('user.deposit.history') }}">
            <a class="sidebar-menu-list__link" href="{{ route('user.deposit.history') }}">
                <span class="icon"><i class="las la-file-invoice-dollar"></i></span>
                <span class="text">@lang('Payment Log')</span>
            </a>
        </li>
        <li class="sidebar-menu-list__item {{ menuActive('user.profile.setting') }}">
            <a class="sidebar-menu-list__link" href="{{ route('user.profile.setting') }}">
                <span class="icon"><i class="las la-user-cog"></i></span>
                <span class="text"> @lang('Profile Setting') </span>
            </a>
        </li>
        <li class="sidebar-menu-list__item {{ menuActive('ticket.index') }}">
            <a class="sidebar-menu-list__link" href="{{ route('ticket.index') }}">
                <span class="icon"><i class="las la-ticket-alt"></i></span>
                <span class="text"> @lang('Support Ticket') </span>
            </a>
        </li>
        <li class="sidebar-menu-list__item {{ menuActive('user.change.password') }}">
            <a class="sidebar-menu-list__link" href="{{ route('user.change.password') }}">
                <span class="icon"><i class="lab la-keycdn"></i></span>
                <span class="text"> @lang('Change Password') </span>
            </a>
        </li>
        <li class="sidebar-menu-list__item">
            <a class="sidebar-menu-list__link" href="{{ route('user.logout') }}">
                <span class="icon"><i class="las la-sign-out-alt"></i></span>
                <span class="text">@lang('Log Out')</span>
            </a>
        </li>
    </ul>
    <!-- ========= Sidebar Menu End ================ -->
    <h5 class="dashboard-sidebar__title">@lang('Subscription Plan')</h5>
    @if ($plan)
        <div class="dashboard-widget plan-expired justify-content-center bg--success">
            <div class="text-center">
                <span class="caption">@lang('Active Plan'): {{ __(@$plan->plan->title) }}</span>
                <span class="caption"> @lang('Current Plan Expired On')</span>
                <h6 class="date">{{ showDateTime($plan->expired_on, 'd M, Y') }}</h6>
            </div>
        </div>
    @endif
    <div class="plan-card">
        <div class="plan-card-body">
            @if ($plan)
                <h6 class="mb-1 p-0 text-center">@lang('Pricing Info.')</h6>
                <p class="pricing-card__title mb-3 text-center">{{ __(@$plan->plan->title) }}</p>
                <ul class="pricing-card__list">
                    <li class="pricing-card__item">
                        <div class="d-flex justify-content-between">
                            <span>
                                <span class="pricing-card__item-icon text--base"><i class="las la-building"></i></span>
                                @lang('Properties')
                            </span>
                            <span class="text--success">{{ @$plan->properties }} </span>
                        </div>
                    </li>

                    <li class="pricing-card__item">
                        <div class="d-flex justify-content-between">
                            <span>
                                <span class="pricing-card__item-icon text--base">
                                    <i class="las la-american-sign-language-interpreting"></i></span>
                                @lang('Amenities')
                            </span>
                            <span class="@if (@$plan->amenities) text--success @else text--danger @endif">{{ @$plan->amenities }} </span>
                        </div>
                    </li>

                    <li class="pricing-card__item">
                        <div class="d-flex justify-content-between">
                            <span>
                                <span class="pricing-card__item-icon text--base">
                                    <i class="la la-image  la-times"></i>
                                </span>
                                @lang('Images')
                            </span>
                            <span class="@if (@$plan->images) text--success @else text--danger @endif">{{ $plan->images }} </span>
                        </div>
                    </li>

                    <li class="pricing-card__item">
                        <div class="d-flex justify-content-between">
                            <span>
                                <span class="pricing-card__item-icon text--base">
                                    <i class="la la-video  la-times"></i>
                                </span>

                                @lang('Videos')
                            </span>
                            <span class="@if (@$plan->videos) text--success @else text--danger @endif">{{ $plan->videos }} </span>
                        </div>
                    </li>

                    <li class="pricing-card__item">
                        <div class="d-flex justify-content-between">
                            <span>
                                <span class="pricing-card__item-icon text--base">
                                    <i class="las la-map-marker-alt"></i>
                                </span>
                                @lang('Google map')
                            </span>
                            <span class="@if (@$plan->map) text--success @else text--danger @endif">
                                @if ($plan->map)
                                    @lang('Yes')
                                @else
                                    @lang('No')
                                @endif
                            </span>
                        </div>
                    </li>
                </ul>
            @else
                <h5 class="text-center">@lang('No Active Plan')</h5>
                <p class="mb-4">@lang('Currently, you have no subscribed plan. Please buy a plan to publish your properties or add new properties.')</p>

                <div class="text-center">
                    <a class="btn btn--sm btn--base" href="{{ route('pricing') }}"><i class="las la-shopping-bag"></i> @lang('Buy a Plan')</a>
                </div>
            @endif
        </div>
    </div>

</div>
