<form action="{{ route('properties') }}" method="GET" autocomplete="off" class="filter-main-sidebar">
    <div class="property-sidebar">
        <button class="property-sidebar__close d-xl-none d-inline-block" type="button"><i class="las la-times"></i></button>
        <div class="property-sidebar__wrapper">
            <div class="property-sidebar__select form-group">
                <select class="filter-select form-select form--control" name="property_status">
                    <option value=""> @lang('All Type') </option>
                    <option value="{{ Status::BUY }}" @selected(request()->property_status == Status::BUY)> @lang('Buy') </option>
                    <option value="{{ Status::RENT }}" @selected(request()->property_status == Status::RENT)> @lang('Rent') </option>
                </select>
            </div>
            <div class="property-sidebar__select form-group">
                <select class="filter-select form-select form--control" name="category_id">
                    <option value=""> @lang('All Categories') </option>
                    @foreach ($categories as $category)
                        <option value="{{ $category->id }}" @selected($category->id == request()->category_id)>{{ __($category->name) }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="property-sidebar__select form-group" id="country">
                <select class="filter-select form-select form--control" name="country_id">
                    <option value=""> @lang('All Countries')</option>
                    @foreach ($countries as $country)
                        <option data-cities="{{ $country->cities }}" value="{{ $country->id }}" @selected($country->id == request()->country_id)>{{ __($country->name) }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="property-sidebar__select form-group">
                <select class="filter-select form-select form--control" name="city_id">
                    <option value="">@lang('All Cities')</option>
                    @if (request()->city_id || request()->country_id)
                        @foreach ($cities as $city)
                            <option value="{{ $city->id }}" @selected($city->id == request()->city_id)>{{ __($city->name) }}</option>
                        @endforeach
                    @endif
                </select>

            </div>
            <div class="form-group">
                <input class="form--control form-control" name="location" type="text" value="{{ request()->location }}" placeholder="@lang('Location')">
            </div>
            <div class="form-group">
                <input class="form--control form-control" name="min_price" type="number" value="{{ request()->min_price }}" step="any" placeholder="@lang('Min Price')">
            </div>
            <div class="form-group">
                <input class="form--control form-control" name="max_price" type="number" value="{{ request()->max_price }}" step="any" placeholder="@lang('Max Price')">
            </div>
            <div class="form-group">
                <input class="form--control form-control" name="area_min" type="number" value="{{ request()->area_min }}" step="any" placeholder="@lang('Min Sqft')">
            </div>
            <div class="form-group">
                <input class="form--control form-control" name="area_max" type="number" value="{{ request()->area_max }}" step="any" placeholder="@lang('Max Sqft')">
            </div>
            <div class="form-group">
                <button class="filter-btn btn btn--base w-100" type="submit">@lang('Filter')</button>
            </div>
        </div>
    </div>

</form>

@push('script')
    <script>
        (function($) {
            "use strict";
            $('[name=country_id]').select2({
                dropdownParent: $('[name=country_id]').parent()
            });

            $('[name=category_id]').select2({
                dropdownParent: $('[name=category_id]').parent()
            });

            $('[name=city_id]').select2({
                dropdownParent: $('[name=city_id]').parent()
            });


            //country-cities
            $('select[name="country_id"]').on('change', function() {
                var cities = $(this).find(`option:selected`).data('cities');

                // var option = '';

                var option = "<option name='city_id' value=''>" + "@lang('All Cities')" + "</option>";
                if (cities && cities.length > 0) {
                    $.each(cities, function(index, value) {
                        option += "<option name='city_id' value='" + value.id + "'>" + value.name + "</option>";
                    });
                } else {
                    option = "<option value=''>@lang('Select City')</option>";
                }
                $('select[name=city_id]').html(option);
            })



        })(jQuery);
    </script>
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush

@push('style-lib')
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">
@endpush
