@php
    $language = App\Models\Language::all();
@endphp

<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="{{ route('home') }}">
                <img src="{{ siteLogo('dark') }}">
            </a>
            <button class="navbar-toggler header-button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                type="button" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu align-items-lg-center">
                    <li class="nav-item">
                        <a class="nav-link {{ menuActive('home') }}" href="{{ route('home') }}"
                            aria-current="page">@lang('Home')</a>
                    </li>
                    @php
                        $pages = \App\Models\Page::where('is_default', Status::NO)->where('tempname', activeTemplate())->orderBy('id', 'DESC')->get()
                    @endphp
                    @foreach ($pages as $k => $data)
                        <li class="nav-item">
                            <a class="{{ menuActive('pages', null, $data->slug) }} nav-link"
                                href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a>
                        </li>
                    @endforeach

                    <li class="nav-item">
                        <a class="nav-link {{ menuActive('properties') }}" href="{{ route('properties') }}"
                            aria-current="page">@lang('Properties')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ menuActive('pricing') }}"
                            href="{{ route('pricing') }}">@lang('Plan & Pricing')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ menuActive('article') }}"
                            href="{{ route('article') }}">@lang('Articles')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ menuActive('contact') }}"
                            href="{{ route('contact') }}">@lang('Contact')</a>
                    </li>

                </ul>

                <div class="top-button d-flex flex-wrap gap-3 ms-auto justify-content-between align-items-center">
                    <ul class="login-registration-list d-flex flex-wrap align-items-center">
                        @guest
                            <li class="login-registration-list__item">
                                <span class="login-registration-list__icon"><i class="fas fa-user"></i> </span>
                                <a class="login-registration-list__link"
                                    href="{{ route('user.login') }}">@lang('Login')</a> |
                                <a class="login-registration-list__link"
                                    href="{{ route('user.register') }}">@lang('Register')
                                </a>
                            </li>
                        @else
                            <li class="login-registration-list__item">
                                <span class="login-registration-list__icon"><i class="las la-tachometer-alt"></i></span>
                                <a class="login-registration-list__link"
                                    href="{{ route('user.home') }}">@lang('Dashboard')</a>
                            </li>
                        @endguest
                    </ul>

                    @if (gs()->multi_language)
                        @php
                            $language = App\Models\Language::all();
                            $selectLang = $language->where('code', config('app.locale'))->first();
                        @endphp
                        <div class="language dropdown">
                            <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
                                <div class="language-content">
                                    <div class="language_flag">
                                        <img src="{{ getImage(getFilePath('language') . '/' . $selectLang->image, getFileSize('language')) }}"
                                            alt="flag">
                                    </div>
                                    <p class="language_text_select">{{ __(@$selectLang->name) }}</p>
                                </div>
                                <span class="collapse-icon"><i class="las la-angle-down"></i></span>
                            </button>
                            <div class="dropdown-menu langList_dropdow py-2" style="">
                                <ul class="langList">
                                    @foreach ($language as $item)
                                        <li class="language-list">
                                            <a href="{{ route('lang', $item->code) }}">
                                                <div class="language_flag">
                                                    <img src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}"
                                                        alt="flag">
                                                </div>

                                            </a>
                                            <a href="{{ route('lang', $item->code) }}">
                                                <p
                                                    class="language_text @if (session('lang') == $item->code) custom--dropdown__selected @endif">
                                                    {{ __($item->name) }}</p>
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                    @endif
                </div>
            </div>
        </nav>
    </div>
</header>


@push('script')
    <script>
        $(document).ready(function() {
            const $mainlangList = $(".langList");
            const $langBtn = $(".language-content");
            const $langListItem = $mainlangList.children();

            $langListItem.each(function() {
                const $innerItem = $(this);
                const $languageText = $innerItem.find(".language_text");
                const $languageFlag = $innerItem.find(".language_flag");

                $innerItem.on("click", function(e) {
                    $langBtn.find(".language_text_select").text($languageText.text());
                    $langBtn.find(".language_flag").html($languageFlag.html());
                });
            });
        });
    </script>
@endpush

@push('style')
    <style>
        @media(max-width:991px) {
            .language.dropdown {
                display: inline-block;
                margin-top: 16px;
            }
        }

        .language-wrapper {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            padding: 0;
            border-radius: 4px;
            width: max-content;
            background-color: transparent;
        }

        .language_flag {
            flex-shrink: 0;
            display: flex;
        }

        .language_flag img {
            width: 20px;
            height: 20px;
            object-fit: cover;
            border-radius: 50%;
        }

        .language-wrapper.show .collapse-icon {
            transform: rotate(180deg)
        }

        .collapse-icon {
            font-size: 14px;
            display: flex;
            transition: all linear 0.2s;
            color: hsl(var(--white));
        }

        .language_text_select {
            font-size: 14px;
            font-weight: 600;
            color: hsl(var(--white))
        }

        p.language_text {
            font-size: 13px;
            font-weight: 600;
        }

        .language-content {
            display: flex;
            align-items: center;
            gap: 6px;
        }


        .language_text {
            color: black
        }

        .language-list {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 4px 10px;
            cursor: pointer;
        }

        .language .dropdown-menu {
            position: absolute;
            -webkit-transition: ease-in-out 0.1s;
            transition: ease-in-out 0.1s;
            opacity: 0;
            visibility: hidden;
            top: 100%;
            display: unset;
            background: #fff;
            -webkit-transform: scaleY(1);
            transform: scaleY(1);
            min-width: 120px;
            padding: 5px 0 !important;
            border-radius: 8px;
            border: 1px solid rgb(0 0 0 / 3%);
            left: -10px !important;
        }

        .language .dropdown-menu.show {
            visibility: visible;
            opacity: 1;
        }

        @media(max-width:575px) {
            .header-top-right {
                flex: 1;
            }
        }
    </style>
@endpush
