@extends('Template::layouts.frontend')
@section('content')
    @php
        $bannerContent = getContent('banner.content', true);
        $countries = App\Models\Country::active()
            ->with('cities', function ($q) {
                $q->active();
            })
            ->get();

    @endphp
    <section class="banner-section bg-img" style="background-image: url({{ getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->image, '2250x1500') }});">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="banner-content">
                        <h2 class="banner-content__title text-center">{{ __(@$bannerContent->data_values->heading) }}</h2>
                        <p class="banner-content__desc text-center">{{ __(@$bannerContent->data_values->subheading) }}</p>
                        <form action="{{ route('properties') }}" method="GET" autocomplete="off">

                            <div class="banner-form-wrapper">
                                <div class="keyword">
                                    <input class="form--control" name="search" type="text" autocomplete="off" placeholder="@lang('Enter Search Keyword')">
                                </div>
                                <div class="banner-form">
                                    <div class="location city-select position-relative" id="country-select">
                                        <select class="form-select form--control" name="country_id" aria-label="Default select example">
                                            <option value="">@lang('Select Country')</option>
                                            @foreach ($countries as $country)
                                                <option data-cities="{{ $country->cities }}" value="{{ $country->id }}">{{ __(@$country->name) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="location city-select position-relative" id="city-select">
                                        <select class="form-select form--control" name="city_id" aria-label="Default select example">
                                            <option selected disabled>@lang('Select City')</option>
                                        </select>
                                    </div>
                                    <div class="all-category">
                                        <select class="form-select form--control" name="property_status" aria-label="Default select example">
                                            <option selected disabled> @lang('Property Type') </option>
                                            <option value="1">@lang('Buy') </option>
                                            <option value="2">@lang('Rent')</option>
                                        </select>
                                    </div>
                                    <div class="search-btn">
                                        <button class="btn btn--base w-100" type="submit">@lang('Filter') <span class="icon"><i class="la la-filter"></i></span></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif

@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.location-select select').select2({
                dropdownParent: $('#location-select'),
            });

            $('.country select').select2({
                dropdownParent: $('#country-select'),
            });

            $('.category-select select').select2({
                dropdownParent: $('#category-select'),
            });


            $('.city-select select').select2({
                dropdownParent: $('#city-select'),
            });

            $('select[name="country_id"]').on('change', function() {
                var cities = $(this).find(`option:selected`).data('cities');

                var option = "<option value=''>@lang('Select City')</option>";

                if (cities && cities.length > 0) {
                    $.each(cities, function(index, value) {
                        option += "<option name='city_id' value='" + value.id + "'>" + value.name + "</option>";
                    });
                }
                $('select[name=city_id]').html(option);
            })

        })(jQuery);
    </script>
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush

@push('style-lib')
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">
@endpush
