@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="blog-detials py-120">
        <div class="container">
            <div class="row gy-5 justify-content-center">
                <div class="col-xxl-9 col-xl-8">
                    <div class="blog-details">
                        <div class="blog-details__thumb">

                            <img class="fit-image" src="{{ getImage('assets/images/frontend/article/' . @$blog->data_values->image, '870x520') }}" alt="">
                        </div>
                        <div class="blog-details__content">
                            <div class="flex-between">
                                <span class="blog-details___date"> <i class="las la-calendar-alt"></i> {{ showDateTime($blog->created_at, 'd F Y') }}</span>
                                <span class="blog-details___view-all" title="@lang('Total number of visit')"> <i class="fas fa-eye"></i> {{ shortNumber($blog->view) }}</span>
                            </div>
                            <h3 class="listing-details__title"> {{ __(@$blog->data_values->title) }} </h3>

                            <p class="listing-details__desc"> @php echo @$blog->data_values->description_nic @endphp</p>

                            <div class="blog-details__share mt-4 d-flex align-items-center flex-wrap">
                                <h5 class="social-share__title mb-0 me-sm-3 me-1 d-inline-block">@lang('Share This'):</h5>
                                <ul class="social-list">
                                    <li class="social-list__item"><a class="social-list__link flex-center icon-facebook" href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li class="social-list__item"><a class="social-list__link flex-center icon-twitter" href="https://twitter.com/intent/tweet?text=my share text&amp;url={{ urlencode(url()->current()) }}" target="_blank"> <i class="fab fa-twitter"></i></a>
                                    </li>
                                    <li class="social-list__item"><a class="social-list__link flex-center icon-linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{ urlencode(url()->current()) }}&amp;title=my share text&amp;summary=dit is de linkedin summary" target="_blank"> <i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                    <li class="social-list__item"><a class="social-list__link flex-center icon-google" href="https://plus.google.com/share?url={{ urlencode(url()->current()) }}" target="_blank"> <i class="fab fa-google"></i></a></li>
                                </ul>
                            </div>

                            <!-- Comments Start -->
                            <ul class="comment-list mt-4">
                                <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-4">
                    <!-- ============================= Blog Details Sidebar Start ======================== -->
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title"> @lang('Latest Articles') </h5>
                            @foreach ($latestPosts as $blog)
                                <div class="latest-blog">
                                    <div class="latest-blog__thumb">
                                        <a href="{{ route('article.details', [slug($blog->data_values->title), $blog->id]) }}">
                                            <img class="fit-image" src="{{ getImage('assets/images/frontend/article/thumb_' . @$blog->data_values->image, '350x210') }}"></a>
                                    </div>
                                    <div class="latest-blog__content">
                                        <h6 class="latest-blog__title"><a href="{{ route('article.details', [slug($blog->data_values->title), $blog->id]) }}">{{ __(strLimit($blog->data_values->title, 70)) }}</a>
                                        </h6>
                                        <span class="latest-blog__date fs-13">{{ showDateTime($blog->created_at, 'd F Y') }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <!-- ============================= Blog Details Sidebar End ======================== -->
                </div>
            </div>
        </div>
    </section>
@endsection

@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush
