@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-md-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Image') | @lang('Name')</th>
                                    <th>@lang('Icon') | @lang('Slug')</th>
                                    <th>@lang('Properties')</th>
                                    <th>@lang('Is Featured')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($categories as $category)
                                    <tr>
                                        <td>
                                            <span class="d-block avatar avatar--xs">
                                                <img
                                                    src="{{ getImage(getFilePath('category') . '/' . $category->image, getFileSize('category')) }}">
                                            </span>
                                            {{ __($category->name) }}
                                        </td>
                                        <td>
                                            @php echo $category->icon @endphp
                                            <br>
                                            {{ $category->slug }}
                                        </td>
                                        <td>
                                            <span
                                                class="badge @if ($category->properties_count) badge--primary @else badge--dark @endif">{{ getAmount($category->properties_count) }}</span>
                                        </td>
                                        <td>
                                            @if ($category->is_featured == Status::CATEGORY_FEATURED)
                                                <span class="badge badge--info"> @lang('Yes')</span>
                                            @else
                                                <span class="badge badge--warning"> @lang('No')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php echo $category->statusBadge; @endphp
                                        </td>
                                        @php
                                            $category->image_with_path = getImage(
                                                getFilePath('category') . '/' . $category->image,
                                                getFileSize('category'),
                                            );
                                        @endphp
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-outline--primary editBtn cuModalBtn btn-sm"
                                                    data-modal_title="@lang('Update Category')"
                                                    data-resource="{{ $category }}">
                                                    <i class="las la-pen"></i>@lang('Edit')
                                                </button>
                                                @if ($category->status == Status::ENABLE)
                                                    <button class="btn btn-outline--danger btn-sm confirmationBtn"
                                                        data-question="@lang('Are you sure to disable this category?')"
                                                        data-action="{{ route('admin.category.status', $category->id) }}">
                                                        <i class="las la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-outline--success confirmationBtn btn-sm"
                                                        data-question="@lang('Are you sure to enable this category?')"
                                                        data-action="{{ route('admin.category.status', $category->id) }}">
                                                        <i class="las la-eye"></i>@lang('Enable')
                                                    </button>
                                                @endif

                                                @if ($category->is_featured == Status::CATEGORY_FEATURED)
                                                    <button class="btn btn-outline--warning btn-sm confirmationBtn"
                                                        data-question="@lang('Are you sure to unfeature this category?')"
                                                        data-action="{{ route('admin.category.feature', $category->id) }}">
                                                        <i class="las la-eye-slash"></i>@lang('Unfeature')
                                                    </button>
                                                @else
                                                    <button class="btn btn-outline--info confirmationBtn btn-sm"
                                                        data-question="@lang('Are you sure to feature this category?')"
                                                        data-action="{{ route('admin.category.feature', $category->id) }}">
                                                        <i class="las la-eye"></i>@lang('Feature')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($categories->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($categories) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    @php
        $categoryImage = getImage(getFilePath('category'), getFileSize('category'));
    @endphp
    <!--Cu Modal -->
    <div class="modal fade" id="cuModal" role="dialog" tabindex="-1">
        <div class="modal-dialog  modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.category.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Image')</label>
                                    <x-image-uploader class="w-100" type="category" :required=false />
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Name')</label>
                                    <input class="form-control" name="name" type="text" required>
                                </div>
                                <div class="form-group">
                                    <label>@lang('Slug')</label>
                                    <input class="form-control" name="slug" type="text" required>
                                </div>
                                <div class="form-group">
                                    <label>@lang('Icon')</label>
                                    <div class="input-group">
                                        <input class="form-control iconPicker icon" name="icon" type="text"
                                            autocomplete="off" required>
                                        <span class="input-group-text input-group-addon" data-icon="las la-home"
                                            role="iconpicker"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection
@push('breadcrumb-plugins')
    <x-search-form />
    <button class="btn btn-sm btn-outline--primary cuModalBtn" data-modal_title="@lang('Add Category')">
        <i class="las la-plus"></i>@lang('Add New')
    </button>
@endpush
@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}">
@endpush
@push('script-lib')
    <script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('[name=name]').on('keyup', function() {
                let inputString = $(this).val();
                var slug = createSlug(inputString);
                $('[name=slug]').val(slug);
            })

            function createSlug(inputString) {
                var slug = inputString.toLowerCase()
                    .replace(/[^\w\-]+/g, '-')
                    .replace(/\-+/g, '-')
                    .replace(/^-+|-+$/g, '');
                return slug;
            }

            $('.cuModalBtn').on('click', function() {
                var resource = $(this).data('resource');
                $('#cuModal').find('[name=image]').removeAttr('required');
                $('#cuModal').find('[name=image]').closest('.form-group').find('label').first().removeClass(
                    'required');

                const imagePath = @json(route('home') . '/' . getFilePath('category'));
                var imageUrl;
                if (resource.image) {
                    imageUrl = `${imagePath}/${resource.image}`;
                } else {
                    imageUrl = '{{ getImage(null, getFileSize('category')) }}';
                }
                $(".image-upload-preview").css({
                    "background-image": "url('" + imageUrl + "')"
                });
            });

            $('#cuModal').on('show.bs.modal', function() {
                loadOldIcons();
            });

            $('.iconPicker').iconpicker().on('iconpickerSelected', function(e) {
                $(this).closest('.form-group').find('.iconpicker-input').val(
                    `<i class="${e.iconpickerValue}"></i>`);
            });

            function loadOldIcons() {
                $('.iconPicker').closest('.form-group').find('.input-group-text.input-group-addon').html(
                    function() {
                        return $(this).closest('.form-group').find('.iconPicker').val();
                    });
            }

            loadOldIcons();
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .icon i {
            font-size: 25px;
        }
    </style>
@endpush
