<?php

namespace App\Models;


use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    use GlobalStatus;

    public function properties()
    {
        return $this->hasMany(Property::class);
    }
    
    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function scopeHasProperties($query)
    {
        return $query->whereHas('properties', function ($q) {
            $q->approved();
        });
    }
}
