<?php

namespace App\Lib;

use App\Constants\Status;
use App\Models\AdminNotification;
use App\Models\Property;
use App\Models\PropertyImage;
use App\Models\UserPlan;

class PlanSubscription {
    public $plan;
    public $user;

    public function __construct($plan, $user) {
        $this->plan = $plan;
        $this->user = $user;
    }

    public function subscribe() {

        $lastPlan = $this->user->plans()->where('status', Status::ENABLE)->first();

        if ($lastPlan) {
            $lastPlan->status = Status::DISABLE;
            $lastPlan->save();
        }

        $userPlan = new UserPlan();
        $userPlan->user_id         = $this->user->id;
        $userPlan->plan_id         = $this->plan->id;
        $userPlan->plan_price      = $this->plan->price;
        $userPlan->properties      = $this->plan->properties;
        $userPlan->amenities       = $this->plan->amenities;
        $userPlan->images          = $this->plan->images;
        $userPlan->videos          = $this->plan->videos;
        $userPlan->allow_map       = $this->plan->map;
        $userPlan->expired_on      = $this->plan->expired_on;
        $userPlan->save();
    }

    public function disabledExtraProperties() {

        $approvedProperties = Property::approved()->where('user_id', $this->user->id)->orderBy('id', 'asc')->get();

        $oldApprovedPropertyCount = $approvedProperties->count();

        $newPropertyCount = $this->plan->properties;

        if ($oldApprovedPropertyCount > $newPropertyCount) {
            $inactivePropertyCount = $oldApprovedPropertyCount - $newPropertyCount;
            // Get IDs of those properties to be inactivated
            $inactivePropertyIds = $approvedProperties
                ->take($inactivePropertyCount)
                ->pluck('id');


            Property::whereIn('id', $inactivePropertyIds)->update(['status' => Status::PROPERTY_DISABLED]);

            $adminNotification = new AdminNotification();
            $adminNotification->user_id = $this->user->id;
            $adminNotification->title = 'Property plan drown grade by ' . $this->user->username;
            $adminNotification->click_url = urlPath('admin.property.pending');
            $adminNotification->save();
        }
    }

    public function removeExtraData() {
        $properties = Property::where('user_id', $this->user->id)->get();

        foreach ($properties as $property) {

            if ($this->plan->map == Status::NO) {
                $property->map = null;
            }

            $oldAmenities = $property->amenities ?? [];
            $newAmenitiesCount = $this->plan->amenities;

            if ($newAmenitiesCount === 0) {
                $property->amenities = [];
            } elseif (count($oldAmenities) > $newAmenitiesCount) {
                $property->amenities = array_slice($oldAmenities, -$newAmenitiesCount);
            }

            $oldVideos = $property->videos ?? [];
            $newVideosCount = $this->plan->videos;

            if ($newVideosCount === 0) {
                $property->videos = [];
            } elseif (count($oldVideos) > $newVideosCount) {
                $property->videos = array_slice($oldVideos, -$newVideosCount);
            }


            $property->save();

            $oldImagesCount = PropertyImage::where('property_id', $property->id)->count();
            $newImagesCount = $this->plan->images;
            $popImages = $oldImagesCount - $newImagesCount;

            if ($popImages > 0) {
                $imagesToDelete = PropertyImage::where('property_id', $property->id)
                    ->orderBy('id', 'asc')
                    ->limit($popImages)
                    ->get();

                $path = getFilePath('property');
                foreach ($imagesToDelete as $image) {
                    @unlink($path . '/' . $image->name);
                    $image->delete();
                }
            }
        }
    }
}
