<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Property;
use App\Models\User;

class PropertyController extends Controller
{
    private $pageTitle;

    public function index()
    {
        $this->pageTitle  = 'All Properties';
        return $this->propertyData();
    }

    public function pendingProperties()
    {
        $this->pageTitle = 'Pending Properties';
        return $this->propertyData('pending');
    }
    public function approvedProperties()
    {
        $this->pageTitle = 'Approved Properties';
        return $this->propertyData('approved');
    }
    public function rejectedProperties()
    {
        $this->pageTitle = 'Rejected Properties';
        return $this->propertyData('rejected');
    }
    public function disabledProperties()
    {
        $this->pageTitle = 'Disabled Properties';
        return $this->propertyData('disabled');
    }

    protected function propertyData($scope = null)
    {
        $properties = Property::query();
        if ($scope) {
            $properties = $properties->$scope();
        }

        $pageTitle = $this->pageTitle;
        $properties = $properties
            ->searchable(['title', 'country:name', 'city:name', 'category:name', 'user:username'])
            ->with('category', 'country', 'city', 'images', 'user')
            ->filter(['property_status'])
            ->orderBy('id', 'desc')
            ->paginate(getPaginate());


        return view('admin.property.index', compact('pageTitle', 'properties'));
    }

    public function details($id)
    {

        $pageTitle     = 'Property Details';
        $property      = Property::with('category', 'city', 'images', 'user')->findOrFail($id);
        $totalApproved = Property::approved()->where('user_id', $property->user->id)->count();
        $userPlan      = $property->user->activePlan ?? $property->user->currentPlan;
        return view('admin.property.details', compact('pageTitle', 'property', 'userPlan', 'totalApproved'));
    }

    public function feature($id)
    {
        return Property::changeStatus($id, 'is_featured');
    }

    public function status($id)
    {
        return Property::changeStatus($id);
    }

    public function approve($id)
    {
        $property   = Property::pending()->find($id);
        $user       = $property->user;
        $activePlan = $user->activePlan;

        if (!$activePlan) {
            $notify[] = ['error', 'This user have no active plan now'];
            return back()->withNotify($notify);
        }

        $totalApproved = Property::approved()->where('user_id', $property->user_id)->count();

        if (@$totalApproved >=  $activePlan->properties) {
            $notify[] = ['error', 'According to user plan , maximum properties already approved'];
            $notify[] = ['info', 'If the plan wanna approved , please upgrade his/her plan.'];
            return back()->withNotify($notify);
        }

        $property->status = Status::PROPERTY_APPROVED;
        $property->save();

        notify($user, 'PROPERTY_APPROVED', [
            'title'    => $property->title,
        ]);

        $notify[] = ['success',  "Property approved successfully"];
        return back()->withNotify($notify);
    }

    public function reject($id)
    {
        $property = Property::pending()->find($id);
        $user     = User::findOrFail($property->user_id);

        $property->status = Status::PROPERTY_REJECTED;
        $property->save();

        notify($user, 'PROPERTY_REJECTED', [
            'title'    => $property->title,
        ]);

        $notify[] = ['success',  "Property rejected successfully"];
        return back()->withNotify($notify);
    }
}
