(function ($) {
  "use strict";

  // ============== Header Hide Click On Body Js Start ========
  $('.header-button').on('click', function () {
    $('.body-overlay').toggleClass('show')
  });
  $('.body-overlay').on('click', function () {
    $('.header-button').trigger('click')
    $(this).removeClass('show');
  });
  // =============== Header Hide Click On Body Js End =========

  // ==========================================
  //      Start Document Ready function
  // ==========================================
  $(document).ready(function () {

    // ========================== Header Hide Scroll Bar Js Start =====================
    $('.navbar-toggler.header-button').on('click', function () {
      $('body').toggleClass('scroll-hide-sm')
    });
    $('.body-overlay').on('click', function () {
      $('body').removeClass('scroll-hide-sm')
    });
    // ========================== Header Hide Scroll Bar Js End =====================

    // ========================== add active class to current page Js Start =====================
    function dynamicActiveMenuClass(selector) {
      let FileName = window.location.href.split("/").reverse()[0];

      selector.find("li").each(function () {
        let anchor = $(this).find("a");
        if ($(anchor).attr("href") == FileName) {
          $(this).addClass("active");
        }
      });
      // if any li has active element add class
      selector.children("li").each(function () {
        if ($(this).find(".active").length) {
          $(this).addClass("active");
        }
      });
      // if no file name return
      if ("" == FileName) {
        selector.find("li").eq(0).addClass("active");
      }
    }
    if ($('ul').length) {
      dynamicActiveMenuClass($('ul'));
    }
    // ========================== add active class to current page Js End =====================

    // ========================== Feature SIdebar Js Start =====================
    $('.filter-button').on('click', function () {
      $('.feature-sidebar').addClass('show');
      $('.sidebar-overlay').addClass('show');
    });
    $('.feature-sidebar__close, .sidebar-overlay').on('click', function () {
      $('.feature-sidebar').removeClass('show');
      $('.sidebar-overlay').removeClass('show');
    });

    // ========================== Feature SIdebar Js End =====================



    // ================== Password Show Hide Js Start ==========
    $(".toggle-password").on('click', function () {
      var input = $(this).siblings('input');
      $(this).toggleClass("fa fa-eye-slash");
      if (input.attr("type") == "password") {
        $(input).attr("type", "text");
      } else {
        input.attr("type", "password");
      }
    });
    // =============== Password Show Hide Js End =================

    // ===================== Table Delete Column Js Start =================
    $('.delete-icon').on('click', function () {
      $(this).closest('tr').addClass('d-none')
    });
    // ===================== Table Delete Column Js End =================

    // =========================Gallery magnific Popup Icon Js Start =====================
    $('.gallery-thumb').magnificPopup({
      type: 'image',
      gallery: {
        enabled: true
      }
    });
    // ========================= Gallery magnific Popup Icon Js End =====================

    // ========================= Slick Slider Js Start ==============
    $('.testimonial-slider').slick({
      slidesToShow: 2,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 2000,
      speed: 1500,
      dots: true,
      pauseOnHover: true,
      arrows: false,
      prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-long-arrow-alt-left"></i></button>',
      nextArrow: '<button type="button" class="slick-next"><i class="fas fa-long-arrow-alt-right"></i></button>',
      responsive: [
        {
          breakpoint: 1199,
          settings: {
            arrows: false,
            slidesToShow: 2,
            dots: true,
          }
        },
        {
          breakpoint: 991,
          settings: {
            arrows: false,
            slidesToShow: 1
          }
        },
        {
          breakpoint: 767,
          settings: {
            arrows: false,
            slidesToShow: 1
          }
        }
      ]
    });
    // ========================= Slick Slider Js End ===================

    // ============================ToolTip Js Start=====================
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
    // ============================ToolTip Js End========================

    // ================== Sidebar Menu Js Start ===============
    // Sidebar Dropdown Menu Start
    $(".has-dropdown > a").click(function () {
      $(".sidebar-submenu").slideUp(200);
      if (
        $(this)
          .parent()
          .hasClass("active")
      ) {
        $(".has-dropdown").removeClass("active");
        $(this)
          .parent()
          .removeClass("active");
      } else {
        $(".has-dropdown").removeClass("active");
        $(this)
          .next(".sidebar-submenu")
          .slideDown(200);
        $(this)
          .parent()
          .addClass("active");
      }
    });
    /*============ Sidebar Dropdown Menu End ============*/

    $(".dashboard-sidebar-filter__button").on("click", function () {
      $(".dashboard-sidebar").addClass('show-sidebar');
      $(".sidebar-overlay").addClass('show');
    });
    $(".sidebar-menu__close, .sidebar-overlay").on("click", function () {
      $(".dashboard-sidebar").removeClass('show-sidebar');
      $(".sidebar-overlay").removeClass('show');
    });
    /*================ properties js start ================*/
    $(".filter-icon").on("click", function () {
      $(".property-sidebar").addClass('show-property-sidebar');
      $(".sidebar-overlay").addClass('show');
    });
    $(".property-sidebar__close, .sidebar-overlay").on("click", function () {
      $(".property-sidebar").removeClass('show-property-sidebar');
      $(".sidebar-overlay").removeClass('show');
    });
    /*============ property sidebar js end here ============*/
    // preloader js start 
    // $(window).on("load", function () {
    //   $(".preloader").fadeOut();
    // })

    $(window).on("load", function () {
      $('.preloader').fadeOut();
    })
    
    // preloader js end 


    // ===================== Sidebar Menu Js End =================

    // ==================== Dashboard User Profile Dropdown Start ==================
    $('.user-info__button').on('click', function () {
      $('.user-info-dropdown').toggleClass('show');
    });
    $('.user-info__button').attr('tabindex', -1).focus();

    $('.user-info__button').on('focusout', function () {
      $('.user-info-dropdown').removeClass('show');
    });
    // ==================== Dashboard User Profile Dropdown End ==================

    // ========================= Odometer Counter Up Js End ==========
    $(".counterup-item").each(function () {
      $(this).isInViewport(function (status) {
        if (status === "entered") {
          for (var i = 0; i < document.querySelectorAll(".odometer").length; i++) {
            var el = document.querySelectorAll('.odometer')[i];
            el.innerHTML = el.getAttribute("data-odometer-final");
          }
        }
      });
    });

    $(".counterup-item").each(function () {
      $(this).isInViewport(function (status) {
        if (status === "entered") {
          for (var i = 0; i < document.querySelectorAll(".odometer").length; i++) {
            var el = document.querySelectorAll('.odometer')[i];
            el.innerHTML = el.getAttribute("data-odometer-final");
          }
        }
      });
    });
    // ========================= Odometer Up Counter Js End =====================

  });
  // ==========================================
  //      End Document Ready function
  // ==========================================

  // ========================= Preloader Js Start =====================



  // ========================= Preloader Js End=====================

  // ========================= Header Sticky Js Start ==============
  $(window).on('scroll', function () {
    if ($(window).scrollTop() >= 150) {
      $('.header').addClass('fixed-header');
    }
    else {
      $('.header').removeClass('fixed-header');
    }
  });
  // ========================= Header Sticky Js End===================

  //============================ Scroll To Top Icon Js Start =========
  var btn = $('.scroll-top');

  $(window).scroll(function () {
    if ($(window).scrollTop() > 300) {
      btn.addClass('show');
    } else {
      btn.removeClass('show');
    }
  });

  btn.on('click', function (e) {
    e.preventDefault();
    $('html, body').animate({ scrollTop: 0 }, '300');
  });
  //========================= Scroll To Top Icon Js End ======================
  $("label.form-label").addClass("form--label");

})(jQuery);
